function res=VSWR(gamma)
%
% Usage: res=VSWR(gamma)
%
% Purpose: computes VSWR for given reflection coefficient gamma
%
%   Copyright (c) 2008 by R. Ludwig and G. Bogdanov
%   "RF Circuit Design: Theory and Practice", 2nd edition
%

if nargin<1
   error('Missing data.');
end;

res=(1+abs(gamma))/(1-abs(gamma));