function Gout=Gamma_out(s_param, Gs);
%
% Usage: Gout = Gamma_out(s_param, Gs)
%
% Computes the output reflection coefficient of a network with
% given S-parameters and source reflection coefficient
%
%   Copyright (c) 2008 by R. Ludwig and G. Bogdanov
%   "RF Circuit Design: Theory and Practice", 2nd edition
%

s11=s_param(1,1);
s12=s_param(1,2);
s21=s_param(2,1);
s22=s_param(2,2);

Gout=s22+(s21*s12*Gs)/(1-s11*Gs);