function Gin=Gamma_in(s_param, GL);
%
% Usage: Gin = Gamma_in(s_param, GL)
%
% Computes the input reflection coefficient of a network with
% given S-parameters and load reflection coefficient
%
%   Copyright (c) 2008 by R. Ludwig and G. Bogdanov
%   "RF Circuit Design: Theory and Practice", 2nd edition
%

s11=s_param(1,1);
s12=s_param(1,2);
s21=s_param(2,1);
s22=s_param(2,2);

Gin=s11+(s21*s12*GL)/(1-s22*GL);