function H=Z_to_H(Z);
% converts Z-parameters to h-parameters
%
% Usage: H = Z_to_H(Z)
%
%   Copyright (c) 2008 by R. Ludwig and G. Bogdanov
%   "RF Circuit Design: Theory and Practice", 2nd edition
%

z11=Z(1,1);
z12=Z(1,2);
z21=Z(2,1);
z22=Z(2,2);

h11=det(Z);
h12=z12;
h21=-z21;
h22=1;

H=[h11,h12;h21,h22]/z22;

