function Z=S_to_Z(s_param,Z0);
% converts S-parameters to Z-parameters
%
% Usage: Z = S_to_Z(s_param,Z0)
%
%   Copyright (c) 2008 by R. Ludwig and G. Bogdanov
%   "RF Circuit Design: Theory and Practice", 2nd edition
%

s11=s_param(1,1);
s12=s_param(1,2);
s21=s_param(2,1);
s22=s_param(2,2);

delta=(1-s11)*(1-s22)-s12*s21;

z11=((1+s11)*(1-s22)+s12*s21)/delta;
z12=2*s12/delta;
z21=2*s21/delta;
z22=((1-s11)*(1+s22)+s12*s21)/delta;

Z=[z11,z12;z21,z22]*Z0;
