function Y=H_to_Y(H);
% converts h-parameters to Y-parameters
%
% Usage: Y = H_to_Y(H)
%
%   Copyright (c) 2008 by R. Ludwig and G. Bogdanov
%   "RF Circuit Design: Theory and Practice", 2nd edition
%

h11=H(1,1);
h12=H(1,2);
h21=H(2,1);
h22=H(2,2);

y11=1;
y12=-h12;
y21=h21;
y22=det(H);

Y=[y11,y12;y21,y22]/h11;

