function H=ABCD_to_H(abcd_param);
% converts ABCD-parameters to h-parameters
%
% Usage: H = ABCD_to_H(abcd_param)
%
%   Copyright (c) 2008 by R. Ludwig and G. Bogdanov
%   "RF Circuit Design: Theory and Practice", 2nd edition
%

a=abcd_param(1,1);
b=abcd_param(1,2);
c=abcd_param(2,1);
d=abcd_param(2,2);

h11=b;
h12=det(abcd_param);
h21=-1;
h22=c;

H=[h11,h12;h21,h22]/d;
