function side=input_stability(s_param, line_style)
% Usage: side=input_stability(s_param, line_style)
%
% Purpose: plots input stability circle for a given s-parameter matrix
%
% Parameters: 
%            s_param - s-parameter matrix
%            line_style - style of the line which will be used for plot
% Output parameter:
%            side=+1 if stable region is inside of the circle
%            side=-1 if stable region is outside of the circle
%
%   Copyright (c) 2008 by R. Ludwig and G. Bogdanov
%   "RF Circuit Design: Theory and Practice", 2nd edition
%

if nargin==0
   error('Missing S-parameter data.');
end;

hold on;

s11=s_param(1,1);
s12=s_param(1,2);
s21=s_param(2,1);
s22=s_param(2,2);

delta=det(s_param);
rL=abs(s12*s21/(abs(s11)^2-abs(delta)^2));
CL=conj(s11-delta*conj(s22))/(abs(s11)^2-abs(delta)^2);

alpha=2*pi*(0:0.01:1);
if nargin==1
   plot(real(CL)+rL*cos(alpha),imag(CL)+rL*sin(alpha),'LineWidth',2);
else
   plot(real(CL)+rL*cos(alpha),imag(CL)+rL*sin(alpha),line_style,'LineWidth',2);
end;

hold off;

if abs(s22)<1
   if abs(CL)>rL
      side=1;
   else
      side=-1;
   end;
else
   if abs(CL)>rL
      side=-1;
   else
      side=1;
   end;
end;