%
%   This file computes the attenuation profile of the first 
%   order RC filter for various parasitic resistance values
% 
%   Copyright (c) 2008 by R. Ludwig and G. Bogdanov
%   "RF Circuit Design: Theory and Practice", 2nd edition
%

close all; % close all opened graphs
clear all; % clear all variables
f1=figure; % open new graph for the attenuation response
f2=figure; % open new graph for the phase plot

% define problem parameters
C=10e-12; % filter capacitance
R=[0 5 20 50 100 1e3];     % parasitic resistance values
Z0=50;    % characteristic impedance (=source and load impedance)

% define frequency range
f_min=1e6;  % lower frequency limit
f_max=10e9; % upper frequency limit
N=200;      % number of points in the graph
f=f_min*((f_max/f_min).^((0:N)/N)); % compute frequency points on log scale
w=2*pi*f;  

colormap(lines);
color_map=colormap;
colormap('default');

for n=1:length(R)
   S21=2./(1+(R(n)+Z0)*(j*w*C+1/Z0));
   figure(f1);
   semilogx(f,-20*log10(abs(S21)),'color',color_map(n,:));
   hold on;
   phase=angle(S21);
   figure(f2);
   semilogx(f,phase/pi*180,'color',color_map(n,:));
   hold on;
end;

figure(f1);
title('Attenuation profile of the RC filter for various parasitic resistance values');
xlabel('Frequency, Hz');
ylabel('IL, dB');

%print -deps 'fig5_7a.eps'     % if uncommented -> saves a copy of plot in EPS format

figure(f2);
title('Phase response of filter for various parasitic resistance values');
xlabel('Frequency, Hz');
ylabel('Phase, deg');

%print -deps 'fig5_7b.eps'     % if uncommented -> saves a copy of plot in EPS format

