%
%   This file computes the bandstop filter response 
% 
%   Copyright (c) 2008 by R. Ludwig and G. Bogdanov
%   "RF Circuit Design: Theory and Practice", 2nd edition
%

close all; % close all opened graphs
clear all; % clear all variables
figure;    % open new graph

% define problem parameters
C=2e-12;  % filter capacitance
L=5e-9;   % filter inductance
G=5e-3;   % filter resistance
Z0=50;    % characteristic impedance (=source and load impedance)

% define frequency range
f_min=10e6;  % lower frequency limit
f_max=100e9; % upper frequency limit
N=500;       % number of points in the graph
f=f_min*((f_max/f_min).^((0:N)/N)); % compute frequency points on log scale
w=2*pi*f;  

S21=2*Z0*(G+1./(j*w*L)+j*w*C)./(2*Z0*(G+1./(j*w*L)+j*w*C)+1);

semilogx(f,-20*log10(abs(S21)));
title('Bandstop filter response');
xlabel('Frequency, Hz');
ylabel('IL, dB');

%print -deps 'fig5_12a.eps'  % if uncommented -> saves a copy of plot in EPS format

figure;    % open new graph
phase=angle(S21);
semilogx(f,phase/pi*180);
title('Bandstop filter response');
xlabel('Frequency, Hz');
ylabel('Phase, deg');

%print -deps 'fig5_12b.eps'   % if uncommented -> saves a copy of plot in EPS format
