%
%   This file generates the graph for Example 5-1
%   "Band pass filter response" 
% 
%   Copyright (c) 2008 by R. Ludwig and G. Bogdanov
%   "RF Circuit Design: Theory and Practice", 2nd edition
%

close all; % close all opened graphs
clear all; % clear all variables
figure;    % open new graph

% define problem parameters
C=2e-12;  % filter capacitance
L=5e-9;   % filter inductance
R=20;     % filter resistance
Z0=50;    % characteristic impedance (=source and load impedance)

% define frequency range
f_min=10e6;  % lower frequency limit
f_max=100e9; % upper frequency limit
N=100;      % number of points in the graph
f=f_min*((f_max/f_min).^((0:N)/N)); % compute frequency points on log scale
w=2*pi*f;  

S21=2*Z0./(2*Z0+R+(1./(j*w*C)+j*w*L));

semilogx(f,-20*log10(abs(S21)));
title('Bandpass filter response');
xlabel('Frequency, Hz');
ylabel('IL, dB');

%print -deps 'fig5_11a.eps'     % if uncommented -> saves a copy of plot in EPS format

figure;    % open new graph
phase=angle(S21);
semilogx(f,phase/pi*180);
title('Bandpass filter response');
xlabel('Frequency, Hz');
ylabel('Phase, deg.');

%print -deps 'fig5_11b.eps'     % if uncommented -> saves a copy of plot in EPS format


