%
%   This file generates the graph of the skin depth
%   in copper (Cu), aluminum (Al), gold (Au), and solder as
%   a function of operating frequency. 
% 
%   Copyright (c) 2008 by R. Ludwig and G. Bogdanov
%   "RF Circuit Design: Theory and Practice", 2nd edition
%

close all; % close all opened graphs
figure;    % open new graph

% define material conductivities
sigma_Cu=64.5e6;     % copper
sigma_Al=40e6;       % aluminum
sigma_Au=48.5e6;     % gold
sigma_solder=6.38e6; % solder

% permeability of free space
mu0=4*pi*1e-7;

% define frequency in log scale
N=200;       % number points in the graph
fmin=1e4;    % lower frequency limit
fmax=1e9;    % upper frequency limit
f=fmin*((fmax/fmin).^((0:N)/N)); % compute frequency points on log scale

% compute skin depths
delta_Cu=1./sqrt(pi*f*mu0*sigma_Cu);
delta_Al=1./sqrt(pi*f*mu0*sigma_Al);
delta_Au=1./sqrt(pi*f*mu0*sigma_Au);
delta_solder=1./sqrt(pi*f*mu0*sigma_solder);

% generate graph
semilogx(f,delta_Cu,f,delta_Al,f,delta_Au,f,delta_solder);
title('Skin depth as a function of frequency');
xlabel('Frequency {\itf}, Hz');
ylabel('Skin depth {\delta}, m');
legend('Cu','Al','Au','Solder');
axis([1e4 1e9 0 0.002]);

% print -deps 'fig1_4.eps' % if uncommented -> saves a copy of plot in EPS format
