%
%   This file generates the graph for Example 1-3
%   "RF impedance response of metal-film resistors" 
% 
%   Copyright (c) 2008 by R. Ludwig and G. Bogdanov
%   "RF Circuit Design: Theory and Practice", 2nd edition
%

close all; % close all opened graphs
figure;    % open new graph

sigma_Cu=64.5e6;   % define material conductivity
mu=4*pi*1e-7;      % permeability of free space

% define constants for this example
R=2e3;       % resistance in Ohms
C=5e-12;     % capacitance in Farads
l=2*0.025;   % total length of leads in meters (2 leads)
a=2.032e-4;  % radius of the leads in meters (AWG 26)

% define frequency range
f_min=10e3;  % lower frequency limit
f_max=10e9;  % upper frequency limit
N=500;       % number of points in the graph
f=f_min*((f_max/f_min).^((0:N)/N)); % compute frequency points on log scale

L=mu*l/(2*pi)*(log(2*l/a)-1);             % determine inductance
Z=1./(j*2*pi*f*C+1/R)+j*2*pi*f.*L;        % determine impedance

loglog(f,abs(Z));
title('Impedance of a 2 k{\Omega} thin-film resistor as a function of frequency');
xlabel('Frequency {\itf}, Hz');
ylabel('Impedance |Z|, {\Omega}');

% print -deps 'fig1_10.eps' % if uncomment -> saves a copy of plot in EPS format
